{                                                                           }
{ File:       MRUCombos.pas                                                 }
{ Function:   TMRUComboBox component, a ComboBox that adds items entered    }
{             into a most recently used list                                }
{ Language:   Delphi 8 for the Micosoft .NET framework                      }
{ Author:     Rudy Velthuis                                                 }
{                                                                           }

unit MRUCombos;

{$IFNDEF CLR}
{$MESSAGE ERROR 'Only in Delphi for the Microsoft .NET framework'}
{$ENDIF}

interface

uses
  SysUtils, Classes, Controls, StdCtrls;

type
  TCustomMRUComboBox = class(TCustomComboBox)
  private
    FMaxCount: Integer;
    FCaseSensitive: Boolean;
    procedure SetMaxCount(const Value: Integer);
  protected
    function GetItemsClass: TCustomComboBoxStringsClass; override;
    procedure DoExit; override;
    procedure DropDown; override;
    property CaseSensitive: Boolean read FCaseSensitive write FCaseSensitive;
    property MaxCount: Integer read FMaxCount write SetMaxCount default 20;
  public
    procedure UpdateContents; virtual;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;

  TMRUComboBox = class(TCustomMRUComboBox)
  published
    property AutoComplete default True;
    property AutoDropDown default False;
    property AutoCloseUp default False;
    property BevelEdges;
    property BevelInner;
    property BevelKind default bkNone;
    property BevelOuter;
    property Style;                     {Must be published before Items}
    property Anchors;
    property BiDiMode;
    property CaseSensitive;
    property CharCase;
    property Color;
    property Constraints;
    property Ctl3D;
    property DragCursor;
    property DragKind;
    property DragMode;
    property DropDownCount;
    property Enabled;
    property Font;
    property ImeMode;
    property ImeName;
    property ItemHeight;
    property ItemIndex default -1;
    property MaxCount default 20;
    property MaxLength;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Sorted;
    property TabOrder;
    property TabStop;
    property Text;
    property Visible;
    property OnChange;
    property OnClick;
    property OnCloseUp;
    property OnContextPopup;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDrawItem;
    property OnDropDown;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMeasureItem;
    property OnSelect;
    property OnStartDock;
    property OnStartDrag;
    property Items; { Must be published after OnMeasureItem }
  end;

procedure Register;

implementation

uses
  Windows, Messages, Consts;

type
  TMRUComboBoxStrings = class(TCustomComboBoxStrings)
  public
    function Add(const S: string): Integer; override;
    procedure Insert(Index: Integer; const S: string); override;
  end;

procedure Register;
begin
  RegisterComponents('Samples', [TMRUComboBox]);
end;

{ TCustomMRUCombo }

constructor TCustomMRUComboBox.Create(AOwner: TComponent);
begin
  inherited;
  FMaxCount := 20;
end;

destructor TCustomMRUComboBox.Destroy;
begin
  inherited;
end;

procedure TCustomMRUComboBox.DoExit;
begin
  inherited;
  UpdateContents;
end;

procedure TCustomMRUComboBox.DropDown;
begin
  inherited;
  UpdateContents;
end;

function TCustomMRUComboBox.GetItemsClass: TCustomComboBoxStringsClass;
begin
  Result := TMRUComboBoxStrings;
end;

procedure TCustomMRUComboBox.SetMaxCount(const Value: Integer);
begin
  if Value <> FMaxCount then
  begin
    FMaxCount := Value;
    while Value < ItemCount do
      Items.Delete(ItemCount - 1);
  end;
end;

procedure TCustomMRUComboBox.UpdateContents;
begin
  if Text <> '' then
    Items.Add(Text);
  ItemIndex := 0;
end;

{ TMRUComboBoxStrings }

function TMRUComboBoxStrings.Add(const S: string): Integer;
var
  Index: Integer;
begin
  Index := IndexOf(S);
  if TCustomMRUComboBox(ComboBox).FCaseSensitive then
    if Strings[Index] <> S then
      Index := -1;
  if Index = -1 then
    Insert(0, S)
  else
    Move(Index, 0);
  Result := 0;
end;

procedure TMRUComboBoxStrings.Insert(Index: Integer; const S: string);
begin
  if SendTextMessage(ComboBox.Handle, CB_INSERTSTRING, Index, S) < 0 then
    raise EOutOfResources.Create(SInsertLineError);
  if Count > TCustomMRUComboBox(ComboBox).MaxCount then
    Delete(Count - 1);
end;

end.

